/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/

/* -----------------------------------------------------------------------
 * File: sst_prop.cxx
 * Author: Bernhard Holzinger 26.11.96
 * Purpose: System Test property set and get functions
 * ----------------------------------------------------------------------- */

#ifdef BEST_FIRMWARE

#include <capitype.h>


#else

#include <typedefs.h>

#endif

#include <dynamic.h>
#include <errcapi.h>
#include <iocommon.h>
#include <regconst.h>
#include <regx62.h>
#include <regx63.h>
#include <session.h>
#include <sst_prop.h>


b_errtype EXPORT BestSstCfgPropSet( 
  b_handletype handle, 
  b_sstcfgproptype sstcfgprop, 
  b_int32 value              
  )
{
  B_DECLARE_FUNCNAME("BestSstCfgPropSet [sstcfgprpset]");

  B_TRY_VARS_NO_PROG;
  b_int32	prop_addr;
  
  /************************************************************
   * when adding a new property:
   *           - add the new property to the type 
   *             declaration of b_sstcfgproptype
   *             in sst_type.h
   *           - insert the parameter range check
   *             in the switch command below
   *           - insert the property in the 
   *             switch command in BestSstCfgPropGet
   *             before the break command
   *           - change the define for MAX_SST_CFG
   *             in the file sst.c (onboard software)
   ************************************************************/

  B_TRY_BEGIN {
    B_TRY (BestParamCheck (handle, B_PARAM_SSTCFG, (b_int32)sstcfgprop, value));

    if (Best16BitRegisterFile(handle)) {
      B_TRY(BestAbstractPropLongSet(handle, CMD_SSTCFG_PROP_SET,
				    (b_int8)sstcfgprop, value));
    }

    else {
      prop_addr = (b_int32)sstcfgprop;
      B_TRY (BestBasicBlockWrite (handle, SST_CFG_ADDR,
				  (b_int8ptr)&prop_addr, 4));
      B_TRY (BestBasicBlockWrite (handle, SST_CFG_DATA,
				  (b_int8ptr)&value, 4));
    }
  }
  
  B_ERRETURN (B_TRY_RET);
}


b_errtype EXPORT BestSstCfgPropGet (                             
  b_handletype handle,
  b_sstcfgproptype sstcfgprop,
  b_int32 *value             
  )
{
  B_DECLARE_FUNCNAME("BestSstCfgPropGet [sstcfgprpget]");

  B_TRY_VARS_NO_PROG;
  b_int32	prop_addr;

  B_TRY_BEGIN {
    B_TRY_FCT_PARAM_NULL_POINTER (value);
    B_TRY (BestParamProbe (handle, B_PARAM_SSTCFG, (b_int32)sstcfgprop));
    
    if (Best16BitRegisterFile (handle)) {
      B_TRY (BestAbstractPropLongGet (handle, CMD_SSTCFG_PROP_GET,
				      (b_int8)sstcfgprop, value));
    }

    else {
      prop_addr = (b_int32)sstcfgprop;
      B_TRY (BestBasicBlockWrite (handle, SST_CFG_ADDR,
				  (b_int8ptr)&prop_addr, 4));
      B_TRY (BestBasicBlockRead (handle, SST_CFG_DATA,
				 (b_int8ptr)value, 4));
    }
  }

  B_ERRETURN (B_TRY_RET);
}


#ifndef BEST_FIRMWARE

b_errtype EXPORT BestSstCfgPropDefaultSet(                   
  b_handletype handle
  )
{
  B_DECLARE_FUNCNAME("BestSstCfgPropDefaultSet [sstcfgprpdefset]");

  B_TRY_VARS_NO_PROG;
  b_generic_infotype   *GenInfo;
  b_param_infotype     *ParamInfo;
  b_int32 		i;

  B_TRY_BEGIN {
    /* Get pointer to generic info */
    B_TRY (BestGenInfoGet(handle, B_PARAM_SSTCFG, &GenInfo));

    for (i = 0; i < GenInfo -> num_elem; ++i) {
      /* Get pointer to i-th (existing) property */
      B_TRY (BestParamInfoGet(handle, B_PARAM_SSTCFG, i, &ParamInfo,
			      (b_int32)B_INDEX_SEARCH));
      
      /* Set it to default */
      B_TRY (BestSstCfgPropSet (handle,
				ParamInfo -> proptyp.sstcfgprop,
				ParamInfo -> defaultval));
    }
  }

  B_ERRETURN (B_TRY_RET);
}

#endif


b_errtype EXPORT BestSstPropSet (                        
  b_handletype handle,
  b_sstproptype sstprop, 
  b_int32 value         
  )
{
  B_DECLARE_FUNCNAME("BestSstPropSet [sstprpset]");

  B_TRY_VARS_NO_PROG;
  b_int32	prop_addr;
  
    /************************************************************
     * when adding a new property:
     *           - add the new property to the type 
     *             declaration of b_sstproptype
     *             in sst_type.h
     *           - insert the parameter range check
     *             in the switch command below
     *           - insert the property in the 
     *             switch command in BestSstPropGet
     *             before the break command
     *           - change the define for MAX_SST_PROP
     *             in the file sst.c (onboard software)
     ************************************************************/
    
  B_TRY_BEGIN {
    B_TRY (BestParamCheck (handle, B_PARAM_SSTPROP, (b_int32)sstprop, value));

    if (Best16BitRegisterFile(handle)) {
      B_TRY(BestAbstractPropLongSet(handle, CMD_SST_PROP_SET,
				    (b_int8)sstprop, value));
    }

    else {
      prop_addr = (b_int32)sstprop;
      B_TRY (BestBasicBlockWrite (handle, SST_PROP_ADDR,
				  (b_int8ptr)&prop_addr, 4));
      B_TRY (BestBasicBlockWrite (handle, SST_PROP_DATA,
				  (b_int8ptr)&value, 4));
    }
  }
  
  B_ERRETURN (B_TRY_RET);
}


b_errtype EXPORT BestSstPropGet (                             
  b_handletype handle,
  b_sstproptype sstprop,
  b_int32 *value             
  )
{
  B_DECLARE_FUNCNAME("BestSstPropGet [sstprpget]");

  B_TRY_VARS_NO_PROG;
  b_int32	prop_addr;

  B_TRY_BEGIN {
    B_TRY_FCT_PARAM_NULL_POINTER (value);
    B_TRY (BestParamProbe (handle, B_PARAM_SSTPROP, (b_int32)sstprop));
    
    if (Best16BitRegisterFile (handle)) {
      B_TRY (BestAbstractPropLongGet (handle, CMD_SST_PROP_GET,
				      (b_int8)sstprop, value));
    }

    else {
      prop_addr = (b_int32)sstprop;
      B_TRY (BestBasicBlockWrite (handle, SST_PROP_ADDR,
				  (b_int8ptr)&prop_addr, 4));
      B_TRY (BestBasicBlockRead (handle, SST_PROP_DATA,
				 (b_int8ptr)value, 4));
    }
  }

  B_ERRETURN (B_TRY_RET);
}


#ifndef BEST_FIRMWARE

b_errtype EXPORT BestSstPropDefaultSet ( 
  b_handletype handle
  )
{
  B_DECLARE_FUNCNAME("BestSstPropDefaultSet [sstprpdefset]");

  B_TRY_VARS_NO_PROG;
  b_generic_infotype   *GenInfo;
  b_param_infotype     *ParamInfo;
  b_int32 		i;

  B_TRY_BEGIN {
    /* Get pointer to generic info */
    B_TRY (BestGenInfoGet(handle, B_PARAM_SSTPROP, &GenInfo));

    for (i = 0; i < GenInfo -> num_elem; ++i) {
      /* Get pointer to i-th (existing) property */
      B_TRY (BestParamInfoGet(handle, B_PARAM_SSTPROP, i, &ParamInfo,
			      (b_int32)B_INDEX_SEARCH));
      
      /* Set it to default */
      B_TRY (BestSstPropSet (handle,
				ParamInfo -> proptyp.sstprop,
				ParamInfo -> defaultval));
    }
  }

  B_ERRETURN (B_TRY_RET);
}

#endif


